package w83b.w83bOperacionesPaso.w83bPreavisos;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bHistorialPreavisoBean;
import w83b.w83bBeans.W83bImpugnacionesBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bTramitePreavisoBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bDetallesPreavisoOutOPAction extends Q70ActionPasoOP{

	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//Guardamos la accion en el contexto
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		HashMap mapa = (HashMap)contexto.get("w83bMapaPreavisos");
		if ("0".equals(mapa.get("pestania"))){
			W83bPreavisosBean preaviso=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBean");
			contexto.set("w83bprovincia", preaviso.getCentroTrabajo().getCodTerritorio());
			contexto.set("w83bmunicipio", preaviso.getCentroTrabajo().getCodMunicipio());
			contexto.set("w83bprovincia_alt", preaviso.getIdProvincia_alt());
			contexto.set("w83bmunicipio_alt", preaviso.getCodMunicipio_alt());
			W83bUsuarioXLNetsBean usuario= (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
			contexto.set("w83bPerfilUsuario", W83bUtilidadesN38API.elegirAdministradorConsulta(usuario.getPerfilXLNets()));
			contexto.set("w83bCodTerritUsuario", W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets()));
			contexto.set("w83bRegManual", usuario.getRegManual());
			contexto.set("w83bPreavisosNuevoBeanTemp", preaviso);
			return mapping.findForward("paginaDetalles");
		}else{
			JSONObject resultado = new JSONObject ();
			
			if ("1".equals(mapa.get("pestania"))){
				//preaviso original
				W83bPreavisosBean preavisoOriginal=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBean");
				resultado.put("cif", preavisoOriginal.getCentroTrabajo().getCifnif());
				resultado.put("numCentro", preavisoOriginal.getCentroTrabajo().getNumCentro());
				resultado.put("razonSocial", preavisoOriginal.getCentroTrabajo().getRazonSocial());
				resultado.put("codTerritorio", preavisoOriginal.getCentroTrabajo().getCodTerritorio());
				resultado.put("territorio", preavisoOriginal.getCentroTrabajo().getTerritorio());
				resultado.put("codMunicipio", preavisoOriginal.getCentroTrabajo().getCodMunicipio());
				resultado.put("municipio", preavisoOriginal.getCentroTrabajo().getMunicipio());
				resultado.put("fechaEntrada",preavisoOriginal.getFecha_entrada());
				resultado.put("fechaInicio",preavisoOriginal.getFecha_inicio());
				resultado.put("numRegistro",preavisoOriginal.getNum_registro());
				resultado.put("fechaRegistro",preavisoOriginal.getFecha_entrada());
				resultado.put("codConvenio",preavisoOriginal.getCodConvenio());
				resultado.put("descConvenio",preavisoOriginal.getDescConvenio());
				resultado.put("eParcial",preavisoOriginal.getEleccion_parcial());
				resultado.put("prevGlobal",preavisoOriginal.getPreaviso_global());
				resultado.put("admon",preavisoOriginal.getAdmon());
				resultado.put("empresa",preavisoOriginal.getAdmon());
				resultado.put("numtrabajadores",preavisoOriginal.getCentroTrabajo().getNumTrabajadores());
				resultado.put("numcentrosafectados",preavisoOriginal.getNum_centros_afectados());
				resultado.put("fechaEleccion",preavisoOriginal.getFecha_eleccion());
				resultado.put("codTerritActa",preavisoOriginal.getCodterrit_acta());
				resultado.put("anyoActa",preavisoOriginal.getAnyo_acta());
				resultado.put("numActa",preavisoOriginal.getNum_acta());
				resultado.put("idProvincia_alt",preavisoOriginal.getIdProvincia_alt());
				resultado.put("codMunicipio_alt",preavisoOriginal.getCodMunicipio_alt());
				resultado.put("dirAlternativa",preavisoOriginal.getDirAlternativa());
				resultado.put("codPostalAlternativa",preavisoOriginal.getCodPostalAlternativa());
				resultado.put("observaciones",preavisoOriginal.getObservaciones());
				resultado.put("codPromotores",preavisoOriginal.getCodsPromotores());
				resultado.put("descPromotores",preavisoOriginal.getPromotores_desc());
				resultado.put("cnaePreavisoOriginal",preavisoOriginal.getCnaePreavisoOriginal());
				resultado.put("desccnae",preavisoOriginal.getDesccnae());
				resultado.put("telefonoPreavisoOriginal",preavisoOriginal.getTelefonoPreavisoOriginal());
				resultado.put("faxPreavisoOriginal",preavisoOriginal.getFaxPreavisoOriginal());
				resultado.put("emailPreavisoOriginal",preavisoOriginal.getEmailPreavisoOriginal());
				resultado.put("numtrabPreavisoOriginal",preavisoOriginal.getNumtrab());
				resultado.put("territsegsocialPreavisoOriginal",preavisoOriginal.getTerritsegsocial());
				resultado.put("numsegsocialPreavisoOriginal",preavisoOriginal.getNumsegsocial());
				resultado.put("digsegsocialPreavisoOriginal",preavisoOriginal.getDigcontsegsocial());
				resultado.put("fechaRegistroESPreavisoOriginal",preavisoOriginal.getFechaRegistroESPreavisoOriginal());
				resultado.put("numRegistroESPreavisoOriginal",preavisoOriginal.getNumRegistroESPreavisoOriginal());
				
				contexto.set("w83bPreavisoOriginal", preavisoOriginal);
				
				resultado.put("resultado", "ok");
				response.setContentType("text/javascript;charset=iso-8859-1");
				response.setHeader("Pragma", "cache");
				response.setHeader("Expires", "0");
				response.setHeader("Cache-Control", "private");
				response.setStatus(HttpServletResponse.SC_OK);
				PrintWriter out = response.getWriter();
				out.print(resultado.toString());
				out.flush();
				
				return null;
		
			}else if ("2".equals(mapa.get("pestania")))	{
					//docs adjuntos
					W83bPreavisosBean preaviso=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBean");
					JSONArray listaDocs=new JSONArray();
					JSONObject docJSON=null;
					W83bDocBean doc=null;
					for (int i=0;i<preaviso.getListaDocs().size();i++)
					{
						doc=(W83bDocBean)preaviso.getListaDocs().get(i);
						docJSON=new JSONObject();//NOPMD
						docJSON.put("nombreDoc", doc.getNombrePartido());
						docJSON.put("tipoDoc", doc.getTipoDocumento());
						if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(preaviso.getIdioma()))
						{
							docJSON.put("descTipo", doc.getDescTipo());
							docJSON.put("descTramite", doc.getDescTramite());

						}
						else
						{
							docJSON.put("descTipo", doc.getDeseTipo());
							docJSON.put("descTramite", doc.getDeseTramite());

						}
						docJSON.put("idDoc", doc.getId());
						String numRegistro = "";
						String fechaRegistro = "";
						if(StringUtils.isNotEmpty(doc.getNumeroRegistro())){
							numRegistro = doc.getNumeroRegistro();
						}
						if(StringUtils.isNotEmpty(doc.getFechaRegistro())){
							fechaRegistro = doc.getFechaRegistro();
						}
						docJSON.put("numRegistro", (numRegistro.length()>8)? numRegistro.substring(0, 8) + " " + numRegistro.substring(8, numRegistro.length()):numRegistro);
						docJSON.put("fechaRegistro", fechaRegistro);
						docJSON.put("usuario", doc.getUsuario());
						docJSON.put("codRemesaAcuse", StringUtils.isNotEmpty(doc.getCodRemesaAcuse())?doc.getCodRemesaAcuse():"");
						docJSON.put("codColeccionAcuse", StringUtils.isNotEmpty(doc.getCodColeccionAcuse())?doc.getCodColeccionAcuse():"");
						docJSON.put("codEnvioAcuse",StringUtils.isNotEmpty(doc.getCodEnvioAcuse())?doc.getCodEnvioAcuse():"");
						
						
						listaDocs.put(docJSON);

					}
					resultado.put("listaDocs",listaDocs);
					
					resultado.put("resultado", "ok");
					response.setContentType("text/javascript;charset=iso-8859-1");
					response.setHeader("Pragma", "cache");
					response.setHeader("Expires", "0");
					response.setHeader("Cache-Control", "private");
					response.setStatus(HttpServletResponse.SC_OK);
					PrintWriter out = response.getWriter();
					out.print(resultado.toString());
					out.flush();
					
					return null;

				}
				else
					if ("3".equals(mapa.get("pestania")))
					{
						//impugnaciones
						W83bPreavisosBean preaviso=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBean");
						W83bImpugnacionesBean impugnacionBean=new W83bImpugnacionesBean();
						impugnacionBean = (W83bImpugnacionesBean)W83bUtilidadesComunes.inicializarPaginador(request, impugnacionBean);
						int num_paginas = (preaviso.getListaImpugnaciones().size()/Integer.parseInt(impugnacionBean.getTotal()));
						
						W83bPreavisosBean preavisoTemp=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBeanTemp");
						List listaImpugnaciones = new ArrayList();
						for(int i=0,size=preaviso.getListaImpugnaciones().size();i<size;i++){
							W83bImpugnacionesBean bean = new W83bImpugnacionesBean((W83bImpugnacionesBean)preaviso.getListaImpugnaciones().get(i));//NOPMD
							
							listaImpugnaciones.add(bean);
						}
						preavisoTemp.setListaImpugnaciones(listaImpugnaciones);
						contexto.set("w83bPreavisosNuevoBeanTemp",preavisoTemp);
						
						if(preaviso.getListaImpugnaciones().size()%Integer.parseInt(impugnacionBean.getTotal())>0){
							num_paginas++;
						}
						impugnacionBean.setRows(String.valueOf(num_paginas));
						
						
						List listaVariables = new ArrayList();
						
						listaVariables.add("num_impugnacion");
						listaVariables.add("fecha_impugnacion");
						listaVariables.add("tipo");
						listaVariables.add("impugnante");
						listaVariables.add("sindicatos");
						listaVariables.add("dni_arbitro");
						listaVariables.add("nombre_arbitro");
						listaVariables.add("num_laudo");
						listaVariables.add("fech_laudo");
						listaVariables.add("fech_envio_juzgado");
						listaVariables.add("fech_sentencia");
						listaVariables.add("fech_baja_desest");
						listaVariables.add("resultado");
						String varClave = "num_impugnacion";
						
						
						String jJson = W83bUtilidadesComunes.procesarTablaConId(preaviso.getListaImpugnaciones(),listaVariables,varClave,W83bImpugnacionesBean.class, impugnacionBean);
						
						response.setContentType("text/javascript;charset=iso-8859-1");
						response.setHeader("Pragma", "cache");
						response.setHeader("Expires", "0");
						response.setHeader("Cache-Control", "private");
						response.setStatus(HttpServletResponse.SC_OK);
						PrintWriter out = response.getWriter();
						out.print(jJson);
						out.flush();
					}
					else
						if ("4".equals(mapa.get("pestania")))
						{
							if ("1".equals(mapa.get("grid")))
							{
								//historial	
								W83bPreavisosBean preaviso=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBean");
								W83bHistorialPreavisoBean historialPreavisoBean=new W83bHistorialPreavisoBean();
								historialPreavisoBean = (W83bHistorialPreavisoBean)W83bUtilidadesComunes.inicializarPaginador(request, historialPreavisoBean);
								int num_paginas = (preaviso.getListaHistorial().size()/Integer.parseInt(historialPreavisoBean.getTotal()));
								
								
								if(preaviso.getListaHistorial().size()%Integer.parseInt(historialPreavisoBean.getTotal())>0){
									num_paginas++;
								}
								historialPreavisoBean.setRows(String.valueOf(num_paginas));
								
								
								List listaVariables = new ArrayList();
								
								listaVariables.add("dia_actuacion");
								listaVariables.add("hora_actuacion");
								listaVariables.add("descripcion");
								listaVariables.add("usuario");
								
								
								String varClave = null;
								
								
								String jJson = W83bUtilidadesComunes.procesarTabla(preaviso.getListaHistorial(),listaVariables,varClave,W83bHistorialPreavisoBean.class, historialPreavisoBean);
								
								response.setContentType("text/javascript;charset=iso-8859-1");
								response.setHeader("Pragma", "cache");
								response.setHeader("Expires", "0");
								response.setHeader("Cache-Control", "private");
								response.setStatus(HttpServletResponse.SC_OK);
								PrintWriter out = response.getWriter();
								out.print(jJson);
								out.flush();

							}
							else
							{
								//tramites
								W83bPreavisosBean preaviso=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBean");
								W83bTramitePreavisoBean tramitePreavisoBean=new W83bTramitePreavisoBean();
								tramitePreavisoBean = (W83bTramitePreavisoBean)W83bUtilidadesComunes.inicializarPaginador(request, tramitePreavisoBean);
								int num_paginas = (preaviso.getListaTramites().size()/Integer.parseInt(tramitePreavisoBean.getTotal()));
								
								
								if(preaviso.getListaTramites().size()%Integer.parseInt(tramitePreavisoBean.getTotal())>0){
									num_paginas++;
								}
								tramitePreavisoBean.setRows(String.valueOf(num_paginas));
								
								
								List listaVariables = new ArrayList();
								
								listaVariables.add("descFase");
								listaVariables.add("desc_tramite");
								listaVariables.add("fecha_tramite");
								listaVariables.add("usuario_alta");
								listaVariables.add("fecha_alta");
								listaVariables.add("usuario_modif");
								listaVariables.add("fecha_modif");

								
								String varClave = null;
								
								
								String jJson = W83bUtilidadesComunes.procesarTabla(preaviso.getListaTramites(),listaVariables,varClave,W83bTramitePreavisoBean.class, tramitePreavisoBean);
								
								response.setContentType("text/javascript;charset=iso-8859-1");
								response.setHeader("Pragma", "cache");
								response.setHeader("Expires", "0");
								response.setHeader("Cache-Control", "private");
								response.setStatus(HttpServletResponse.SC_OK);
								PrintWriter out = response.getWriter();
								out.print(jJson);
								out.flush();
							}
							
						}
			return null;
		}
		
	}
}
